<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ext_shopify_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shopify_store_id')->constrained('ext_shopify_stores')->onDelete('cascade');
            $table->unsignedBigInteger('shopify_order_id');
            $table->string('order_number')->nullable();
            $table->string('customer_email')->nullable();
            $table->string('customer_name')->nullable();
            $table->string('customer_phone')->nullable();
            $table->decimal('total_price', 10, 2)->default(0);
            $table->decimal('subtotal_price', 10, 2)->default(0);
            $table->decimal('total_tax', 10, 2)->default(0);
            $table->decimal('total_discounts', 10, 2)->default(0);
            $table->string('currency', 3)->default('USD');
            $table->string('financial_status')->nullable();
            $table->string('fulfillment_status')->nullable();
            $table->integer('total_items')->default(0);
            $table->json('line_items')->nullable();
            $table->json('shipping_address')->nullable();
            $table->json('billing_address')->nullable();
            $table->string('utm_source')->nullable();
            $table->string('utm_medium')->nullable();
            $table->string('utm_campaign')->nullable();
            $table->text('landing_site')->nullable();
            $table->text('referring_site')->nullable();
            $table->timestamp('shopify_created_at')->nullable();
            $table->timestamp('shopify_updated_at')->nullable();
            $table->timestamps();
            
            $table->index('shopify_store_id');
            $table->index('shopify_order_id');
            $table->index('customer_email');
            $table->index('financial_status');
            $table->index('utm_campaign');
            $table->index('shopify_created_at');
            $table->unique(['shopify_store_id', 'shopify_order_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ext_shopify_orders');
    }
};
